/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AttributeInfo;
import dioscuri.module.cpu32.ClassFile;
import dioscuri.module.cpu32.ConstantPoolInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodInfo {
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private AttributeInfo[] attributes;
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int BRIDGE = 64;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYTHETIC = 4096;

    public MethodInfo(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
        this.nameIndex = dataInputStream.readUnsignedShort();
        this.descriptorIndex = dataInputStream.readUnsignedShort();
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeInfo.construct(dataInputStream, constantPoolInfoArray);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.descriptorIndex);
        dataOutputStream.writeShort(this.attributesCount);
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i].write(dataOutputStream);
        }
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public int getMaxStack() {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            return ((AttributeInfo.CodeAttribute)this.attributes[i]).getMaxStack();
        }
        return 0;
    }

    public int getMaxLocals() {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            return ((AttributeInfo.CodeAttribute)this.attributes[i]).getMaxLocals();
        }
        return 0;
    }

    public int[] getCode() {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            return ((AttributeInfo.CodeAttribute)this.attributes[i]).getCode();
        }
        return null;
    }

    public void setCode(int[] nArray, ClassFile classFile) {
        this.setCode(nArray, nArray.length, classFile);
    }

    public void setCode(int[] nArray, int n, ClassFile classFile) {
        String string = classFile.getConstantPoolUtf8(this.getDescriptorIndex());
        int n2 = classFile.getMethodArgLength(string);
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            ((AttributeInfo.CodeAttribute)this.attributes[i]).setCode(nArray, n, classFile, n2);
            return;
        }
    }

    public AttributeInfo.CodeAttribute.ExceptionEntry[] getExceptionTable() {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            return ((AttributeInfo.CodeAttribute)this.attributes[i]).getExceptionTable();
        }
        return null;
    }

    public void setExceptionTable(AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray, ClassFile classFile) {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            ((AttributeInfo.CodeAttribute)this.attributes[i]).setExceptionTable(exceptionEntryArray, exceptionEntryArray.length, classFile);
            return;
        }
    }

    public void setExceptionTable(AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray, int n, ClassFile classFile) {
        for (int i = 0; i < this.attributesCount; ++i) {
            if (!(this.attributes[i] instanceof AttributeInfo.CodeAttribute)) continue;
            ((AttributeInfo.CodeAttribute)this.attributes[i]).setExceptionTable(exceptionEntryArray, n, classFile);
            return;
        }
    }
}

